/*
 * Decompiled with CFR 0.152.
 */
package moe.ytonidc.dimensional_stomach;

import moe.ytonidc.dimensional_stomach.StomachCapability;
import moe.ytonidc.dimensional_stomach.StomachInit;
import moe.ytonidc.dimensional_stomach.StomachSlotManager;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.SlotItemHandler;

public class StomachMenu
extends AbstractContainerMenu {
    private final Player player;
    private final StomachSlotManager slotManager;
    private final StomachSlotManager.SlotType slotType;
    private final int stomachLevel;
    private final int unlockedSlots;
    private final ItemStackHandler placeholderHandler;
    private final ContainerData data;
    private static final int BONUS_SCALE = 100;
    private static final int SLOT_SIZE = 18;
    private static final int SLOTS_PER_ROW = 9;
    private static final int ROWS = 4;

    public StomachMenu(MenuType<?> menuType, int windowId, Inventory playerInventory, StomachSlotManager.SlotType slotType) {
        this(menuType, windowId, playerInventory, slotType, -1, -1, (ContainerData)new SimpleContainerData(1));
    }

    public StomachMenu(MenuType<?> menuType, int windowId, Inventory playerInventory, StomachSlotManager.SlotType slotType, int stomachLevel, int unlockedSlots) {
        this(menuType, windowId, playerInventory, slotType, stomachLevel, unlockedSlots, (ContainerData)new SimpleContainerData(1));
    }

    public StomachMenu(MenuType<?> menuType, int windowId, Inventory playerInventory, StomachSlotManager.SlotType slotType, int stomachLevel, int unlockedSlots, ContainerData data) {
        super(menuType, windowId);
        int col;
        int row;
        this.player = playerInventory.f_35978_;
        this.slotManager = StomachCapability.getSlotManager(this.player);
        this.slotType = slotType;
        this.data = data;
        if (stomachLevel < 0) {
            this.stomachLevel = this.slotManager.getStomachLevel();
            this.unlockedSlots = this.slotManager.getUnlockedSlots();
        } else {
            this.stomachLevel = stomachLevel;
            this.unlockedSlots = unlockedSlots;
        }
        this.updateBonusData();
        this.placeholderHandler = new ItemStackHandler(36);
        ItemStack placeholder = switch (slotType) {
            default -> throw new IncompatibleClassChangeError();
            case StomachSlotManager.SlotType.RED -> new ItemStack((ItemLike)Items.f_42190_);
            case StomachSlotManager.SlotType.BLUE -> new ItemStack((ItemLike)Items.f_42187_);
            case StomachSlotManager.SlotType.YELLOW -> new ItemStack((ItemLike)Items.f_42180_);
        };
        placeholder.m_41714_((Component)Component.m_237113_((String)"\u00a7c\u672a\u89e3\u9501"));
        for (int i = 0; i < 36; ++i) {
            this.placeholderHandler.setStackInSlot(i, placeholder.m_41777_());
        }
        ItemStackHandler handler = this.slotManager.getHandler(slotType);
        int unlocked = this.unlockedSlots;
        for (row = 0; row < 4; ++row) {
            for (col = 0; col < 9; ++col) {
                int index = row * 9 + col;
                int x = 8 + col * 18;
                int y = 18 + row * 18;
                if (index < unlocked) {
                    this.m_38897_((Slot)new StomachSlot((IItemHandler)handler, index, x, y, slotType, this.slotManager, this.player));
                    continue;
                }
                this.m_38897_((Slot)new LockedSlot((IItemHandler)this.placeholderHandler, index, x, y));
            }
        }
        for (row = 0; row < 3; ++row) {
            for (col = 0; col < 9; ++col) {
                this.m_38897_(new Slot((Container)playerInventory, col + row * 9 + 9, 8 + col * 18, 102 + row * 18));
            }
        }
        for (int i = 0; i < 9; ++i) {
            this.m_38897_(new Slot((Container)playerInventory, i, 8 + i * 18, 160));
        }
        this.m_38884_(data);
    }

    public void updateBonusData() {
        if (!this.player.m_9236_().f_46443_) {
            double bonus = this.slotManager.calculateBonus(this.slotType);
            this.data.m_8050_(0, (int)(bonus * 100.0));
        }
    }

    public double getBonus() {
        return (double)this.data.m_6413_(0) / 100.0;
    }

    public static StomachMenu createRed(int windowId, Inventory inv, FriendlyByteBuf data) {
        int level = data.readInt();
        int unlocked = data.readInt();
        return new StomachMenu((MenuType)StomachInit.RED_MENU.get(), windowId, inv, StomachSlotManager.SlotType.RED, level, unlocked);
    }

    public static StomachMenu createBlue(int windowId, Inventory inv, FriendlyByteBuf data) {
        int level = data.readInt();
        int unlocked = data.readInt();
        return new StomachMenu((MenuType)StomachInit.BLUE_MENU.get(), windowId, inv, StomachSlotManager.SlotType.BLUE, level, unlocked);
    }

    public static StomachMenu createYellow(int windowId, Inventory inv, FriendlyByteBuf data) {
        int level = data.readInt();
        int unlocked = data.readInt();
        return new StomachMenu((MenuType)StomachInit.YELLOW_MENU.get(), windowId, inv, StomachSlotManager.SlotType.YELLOW, level, unlocked);
    }

    public ItemStack m_7648_(Player player, int index) {
        ItemStack result = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot != null && slot.m_6657_()) {
            if (slot instanceof LockedSlot) {
                return ItemStack.f_41583_;
            }
            ItemStack stackInSlot = slot.m_7993_();
            result = stackInSlot.m_41777_();
            int stomachSlots = 36;
            if (index < stomachSlots) {
                if (!this.m_38903_(stackInSlot, stomachSlots, this.f_38839_.size(), true)) {
                    return ItemStack.f_41583_;
                }
            } else if (stackInSlot.m_41614_()) {
                if (!this.m_38903_(stackInSlot, 0, this.unlockedSlots, false)) {
                    return ItemStack.f_41583_;
                }
            } else {
                return ItemStack.f_41583_;
            }
            if (stackInSlot.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
        }
        return result;
    }

    public boolean m_6875_(Player player) {
        return true;
    }

    public void m_6877_(Player player) {
        super.m_6877_(player);
        if (!player.m_9236_().f_46443_) {
            this.slotManager.applyAttributes(player);
        }
    }

    public void m_38946_() {
        super.m_38946_();
        this.updateBonusData();
    }

    public StomachSlotManager getSlotManager() {
        return this.slotManager;
    }

    public StomachSlotManager.SlotType getSlotType() {
        return this.slotType;
    }

    public int getStomachLevel() {
        return this.stomachLevel;
    }

    public int getUnlockedSlots() {
        return this.unlockedSlots;
    }

    public static class StomachSlot
    extends SlotItemHandler {
        private final StomachSlotManager.SlotType slotType;
        private final StomachSlotManager manager;
        private final Player player;

        public StomachSlot(IItemHandler handler, int index, int x, int y, StomachSlotManager.SlotType type, StomachSlotManager manager, Player player) {
            super(handler, index, x, y);
            this.slotType = type;
            this.manager = manager;
            this.player = player;
        }

        public boolean m_5857_(ItemStack stack) {
            return stack.m_41614_();
        }

        public int m_6641_() {
            return 1;
        }

        public int m_5866_(ItemStack stack) {
            return 1;
        }

        public void m_5852_(ItemStack stack) {
            super.m_5852_(stack);
            if (!this.player.m_9236_().f_46443_) {
                this.manager.applyAttributes(this.player);
            }
        }

        public ItemStack m_6201_(int amount) {
            ItemStack result = super.m_6201_(amount);
            if (!this.player.m_9236_().f_46443_) {
                this.manager.applyAttributes(this.player);
            }
            return result;
        }

        public void m_142406_(Player player, ItemStack stack) {
            super.m_142406_(player, stack);
            if (!player.m_9236_().f_46443_) {
                this.manager.applyAttributes(player);
            }
        }
    }

    public static class LockedSlot
    extends SlotItemHandler {
        public LockedSlot(IItemHandler handler, int index, int x, int y) {
            super(handler, index, x, y);
        }

        public boolean m_5857_(ItemStack stack) {
            return false;
        }

        public boolean m_8010_(Player player) {
            return false;
        }

        public int m_6641_() {
            return 0;
        }
    }
}

